# -*- coding: utf-8 -*-

import api
import points
import os
from api import sx
from api.bottle import request, response, route, post, run, TEMPLATE_PATH


II_PATH = os.path.dirname(__file__) or '.'
TEMPLATE_PATH.insert(0, II_PATH)

def default_config():
    if not api.ru('server.cfg'): open('server.cfg','w').write('nn.ii.ru naste\nnaste.ne\n')
    if not api.ru('points.txt'): open('points.txt','w').write('guest:guest\n')
default_config()

@route('/lim/<lim:int>/list.txt')
@route('/list.txt')
def list_txt(lim=0):
    response.set_header('content-type', 'text/plain; charset=utf-8')
    lst = api.load_echo(False,lim)[1:]
    if request.query.el:
        el = request.query.el.split('/')
        descs = dict([(a, c) for a, b, c in lst])
        lst = [(x, api.echoarea_count(x,lim), descs[x] if x in descs else '') for x in el]
    if request.query.n:
        return '\n'.join([t[0] for t in lst])
    elif request.query.h:
        return '\n'.join(['%s:%s:%s:%s' % (t[0], t[1], t[2], sx.hsh(api.get_echoarea(t[0], True).encode(),8)) for t in lst])
    else:
        return '\n'.join(['%s:%s:%s' % t for t in lst])


@route('/blacklist.txt')
def blacklist_txt():
    response.set_header('content-type', 'text/plain; charset=utf-8')
    return api.ru('blacklist.txt')


@route('/lim/<lim:int>/u/m/<h:path>')
@route('/u/m/<h:path>')
def jt_outmsg(h,lim=False):
    response.set_header('content-type', 'text/plain; charset=iso-8859-1')
    lst = [x for x in h.split('/') if len(x) == 20 or len(x) == 8]
    return '\n'.join([api.mk_jt(x, api.raw_msg(x)) for x in lst])

@route('/lim/<lim:int>/u/e/<names:path>')
@route('/u/e/<names:path>')
def index_list(names,lim=0):
    response.set_header('content-type', 'text/plain; charset=utf-8')
    lst = api.echoareas(names.split('/'), request.query.sf,lim)
    return lst

@route('/lim/<lim:int>/e/<ea>')
@route('/e/<ea>')
def get_ea(ea,lim=False):
    response.set_header('content-type', 'text/plain; charset=utf-8')
    lst, out = api.get_echoarea_f(ea), ''
    if lim: lst = lst[-lim:]
    for n in lst: out += n + '\n'
    return out

@route('/lim/<lim:int>/m/<h>')
@route('/m/<h>')
def get_h(h,lim=False):
    response.set_header('content-type', 'text/plain; charset=utf-8')
    return api.raw_msg(h)

def _point_msg(pauth, tmsg):
    msgfrom, addr = points.check_hash(pauth)
    if not addr: return 'auth error!'
    cfg = api.load_echo(False)
    mo = api.toss(msgfrom, '%s, %s' % (cfg[0][1], addr), tmsg.strip())
    if mo.msg.startswith('@repto:'):
        tmpmsg = mo.msg.splitlines()
        mo.repto = tmpmsg[0][7:]
        mo.msg = '\n'.join(tmpmsg[1:])
    if len(mo.msg.encode('utf-8')) < 64100:
        h = api.point_newmsg(mo)
        if h:
            return 'msg ok:%s: <a href="/%s">%s</a>' % (h, mo.echoarea, mo.echoarea)
        else:
            return 'error:unknown'
    else:
        return 'msg big!'


@route('/lim/<lim:int>/u/point>/<pauth>/<tmsg:path>')
@route('/u/point/<pauth>/<tmsg:path>')
def point_msg_get(pauth, tmsg, lim=False):
    return _point_msg(pauth, tmsg)


@post('/lim/<lim:int>/u/point>')
@post('/u/point')
def point_msg_post():
    return _point_msg(request.POST['pauth'], request.POST['tmsg'])


@route('/h/f/<fname>')
def get_attach(fname):
    attach, fn = '', ''
    for n in api.raw_msg(fname).splitlines():
        if fn:
            attach += n
        if n.startswith('@base64:'):
            fn = n[8:].strip()
    if fn:
        response.set_header('content-type', 'application/octet-stream')
        response.set_header('content-disposition', 'attachment; filename=%s' % fn)
        response.set_header('content-description', 'File Transfer')
        response.set_header('content-transfer-encoding', 'binary')
        return api.base64.b64decode(attach)


@post('/u/push')
def push_node():
    if not api.ru('node.key'): return 'no auth'
    if api.ru('node.key') != request.forms.nauth: return 'no auth'
    ea = request.forms.echoarea
    if not(api.flt.echo_flt(ea)): return 'invalid echoarea'
    for n in request.forms.upush.splitlines():
        h, s = n.split(':')
        open('m/%s' % h, 'w').write(api.b64d(s))
        open('e/%s' % ea, 'a').write((h + '\n'))


import iitpl
iitpl.II_PATH = II_PATH


run(host='0.0.0.0', port=62221, debug=False)
