import api, api.flt as flt, api.sx as sx, datetime
from iitpl import PyRSS2Gen


def gen_rss(ea,url,num):
    if not flt.echo_flt(ea): return ea
    msgs = []
    for n in reversed(api.get_echoarea_f(ea)[-num:]):
        msg = api.get_msg(n)
        msg.update({'msgid': n})
        msgs.append(msg)
    items = [PyRSS2Gen.RSSItem(
        title=n.subj,description=sx.rend(n.msg,n.msgid),link='http://%s/%s#%s' % (url,ea,n.msgid),
        guid='http://%s/%s' % (url,n.msgid),
        pubDate=datetime.datetime.fromtimestamp(n.date)
    ) for n in msgs ]
    rssout = PyRSS2Gen.RSS2(title=ea,link='http://%s/%s' % (url,ea),description='%s: %s' % (ea,api.get_echo_descr(ea)),
    lastBuildDate=datetime.datetime.now(),items=items)
    return rssout.to_xml('utf-8')
