# -*- coding: utf-8 -*-

import time
from api import bottle
import base64
import hashlib
from api.splitparser import sp


class mydict(dict):
    def __getattr__(self, key):
        return self.get(key, '')

    def __setattr__(self, key, value):
        self[key] = value

    def __add__(self, data):
        k = self.copy()
        k.update(data)
        return mydict(k.items())

    def __sub__(self, key):
        return mydict((k, v) for (k, v) in self.items() if k != key)


def hsh(s,l=20):
    a = base64.urlsafe_b64encode(hashlib.sha256(s).digest())
    a = a.decode('utf-8')
    a = a.replace('-', 'A').replace('_', 'z')[:l]
    return a


def dateg(d, f):
    return time.strftime(f, time.gmtime(int(d)))


def ts_get(d, f=None):
    return time.strptime(d, f or '%d.%m.%Y %H:%M')


def gts():
    return int(time.time())


def rend(txt,msgid):
    out = bottle.html_escape(txt)
    out = sp(out,msgid)
    return out.replace('\n', '<br />')


def g_opts(*n):
    opts = []
    for i in n:
        if i[1]: opts.append('%s=%s' % i)
    if opts: return '?' + '&'.join(opts)
    else: return ''
