import base64
from api import sx
from api import flt
import sys, io, time

def b64c(s):
    return base64.b64encode(s)


def b64d(s):
    return base64.b64decode(s.replace('-', '+').replace('_', '/')).decode()


def _parze(msg):
    pz = msg.splitlines()
    mo = sx.mydict()
    optz = pz[0].split('/')
    mo.update(dict(zip(optz[::2], optz[1::2])))
    for i, n in enumerate(('echoarea', 'date', 'msgfrom', 'addr', 'msgto', 'subj')):
        mo[n] = pz[i+1]
    mo.msg = '\n'.join(pz[8:])
    mo.date = int(mo.date) if mo.date else sx.gts()
    return mo


def _out(mo):
    pz = ['', '', '', '', '', '', '', '', '']
    for i, n in enumerate(('echoarea', 'date', 'msgfrom', 'addr', 'msgto', 'subj')):
        pz[i+1] = mo.get(n, '')
    old = get_msg(mo.repto)
    if old.repto:
        if old.topicid:
            mo.topicid = old.topicid
    else:
        mo.topicid = mo.repto
    pz[0] = '/'.join([x+'/'+y for (x, y) in [('ii', 'ok')] + list(mo.items()) if x not in ('echoarea', 'date', 'msgfrom', 'addr', 'msgto', 'subj', 'msg') and y])
    return '\n'.join(pz) + mo.msg

def _y():
    return time.strftime('%y')

def ru(fn):
    try:
        f = open(fn)
        buf = f.read()
        f.close()
        return buf
    except: return ''


def raw_msg(h):
    if not flt.msg_flt(h): return ''
    txt = ru('m/%s' % h)
    return txt


def get_msg(h):
    txt = raw_msg(h)
    return _parze(txt) if txt else sx.mydict(msg='no message', date=0)


def get_echoarea(name, raw=False):
    if not flt.echo_flt(name): return '' if raw else []
    try:
        txt = open('e/%s' % name).read()
        return txt if raw else txt.splitlines()
    except:
        return '' if raw else []


def get_echoarea_f(name):
    bl = set(ru('blacklist.txt').split())
    return [x for x in get_echoarea(name) if x not in bl]


def echoareas(names, sf, lim=0):
    out = ''
    if sf: sf = set(sf.split('/'))
    for ea in names:
        dllist = get_echoarea_f(ea)
        if sf:
            newhash = [x for x in dllist if x in sf]
            if newhash:
                dllist = dllist[dllist.index(newhash[0]):]
        if lim: dllist = dllist[-lim:]
        dllist = '\n'.join(dllist)
        if dllist: dllist += '\n'
        out += ea + '\n' + dllist
    return out


def echoarea_count(name,lim=0):
    l = len(get_echoarea(name))
    if lim and l > lim:
        l = lim
    return l

def _g(l):
    for n in l:
        x = n.strip().split(' ', 1)
        if len(x) > 1:
            yield x
        elif len(x) == 1 and x[0]:
            yield x[0], ''


def load_echo(filter_star=False,lim=0):
    lst = get_le_lst()
    if filter_star:
        elst = [(x, echoarea_count(x,lim), y) for (x, y) in lst[1:] if not x.startswith('*')]
    else:
        elst = [(x.lstrip('*'), echoarea_count(x.lstrip('*'),lim), y) for (x, y) in lst[1:]]
    return [tuple(lst[0])] + elst


def get_le_lst():
    return [x for x in _g(open('server.cfg').read().splitlines())]


def separate_myel(myel, cfgl):
    tmp = dict(); out = []
    for k, c, v in cfgl:
        tmp[k] = (c, v)
    for x in myel:
        if tmp.get(x):
            out.append((x, tmp[x][0], tmp[x][1]))
        else:
            out.append((x, echoarea_count(x), ''))
    return out


def mk_jt(mh, mb):
    return mh + ':' + b64c(mb.encode()).decode()


def parse_jt(dta):
    for n in dta.splitlines():
        o, m = n.split(':', 1)
        if not raw_msg(o):
            mo = _parze(b64d(m))
            mkmsg(mo, o)


def toss(msgfrom, addr, tmsg):
    lines = b64d(tmsg).splitlines()
    if flt.echo_flt(lines[0]):
        mo = sx.mydict(date=str(sx.gts()), msgfrom=msgfrom, addr=addr, echoarea=lines[0], msgto=lines[1], subj=lines[2], msg='\n'.join(lines[4:]))
        return mo


def _hprefix(txt):
    x = txt.strip().splitlines()
    if x[-1].startswith('+++ memo'):
        hp = x[-1].split(':',1)[1]
        if flt.msg_flt(hp+'12345671234567'):
            return hp


def mkmsg(obj, rh=None):
    if not flt.echo_flt(obj.echoarea): return
    if rh and not flt.msg_flt(rh): return
    hp = _hprefix(obj.msg)
    print (obj.msg)
    s = _out(obj).encode('utf-8')
    h = rh or _y() + sx.hsh(s,18)
    h = hp + h[:14] if hp else h
    if len(s) < 65536:
        open('m/%s' % h, 'wb').write(s)
        open('e/%s' % obj.echoarea, 'ab').write((h + '\n').encode())
        return h


def _filter_msg_call(tags):
    try:
        import filter_msg
        return filter_msg.check(tags)
    except:
        return True

def point_newmsg(tags):
    mo = sx.mydict(date=str(sx.gts()))
    mo.update(**tags)
    if _filter_msg_call(tags): return mkmsg(mo)


def user_echoes(r):
    if r.kuk.myel:
        return r.kuk.myel
    else:
        lst = load_echo(False)[1:]
        return '\n'.join([t[0] for t in lst])


def savemsg(mo):
    hp = _hprefix(mo.msg)
    s = _out(mo).encode('utf-8')
    h = _y() + sx.hsh(s,18)
    h = hp + h[:14] if hp else h
    if len(s) < 65536:
        open('m/%s' % h, 'wb').write(s)
        open('e/%s' % mo.echoarea, 'ab').write((h + '\n').encode())
        return h


def get_echo_descr(ea):
    lst = [x for x in get_le_lst() if x[0] == ea]
    if lst: return lst[0][1]
